/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.common.ExternalLinksUtils;
import info.msxlaunchers.openmsx.common.version.VersionUtils;
import info.msxlaunchers.openmsx.launcher.data.extra.ExtraData;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.extra.ExtraDataGetter;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistence;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.settings.SettingsPersister;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.UpdateCheckerPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.UpdateCheckerView;
import info.msxlaunchers.openmsx.launcher.updater.FileUpdateFailedException;
import info.msxlaunchers.openmsx.launcher.updater.UpdateChecker;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

final class UpdateCheckerPresenterImpl
implements UpdateCheckerPresenter {
    private final UpdateCheckerView view;
    private final UpdateChecker updateChecker;
    private final ExtraDataGetter extraDataGetter;
    private final SettingsPersister settingsPersister;
    private final LauncherPersistence launcherPersistence;
    private final MainPresenter mainPresenter;
    private static final String DOWNLOAD_URL = "http://msxlaunchers.info/download.html";
    private Map<String, String> versionsFromServer;

    @Inject
    UpdateCheckerPresenterImpl(UpdateCheckerView view, UpdateChecker updateChecker, ExtraDataGetter extraDataGetter, SettingsPersister settingsPersister, LauncherPersistence launcherPersistence, MainPresenter mainPresenter) {
        this.view = Objects.requireNonNull(view);
        this.updateChecker = Objects.requireNonNull(updateChecker);
        this.extraDataGetter = Objects.requireNonNull(extraDataGetter);
        this.settingsPersister = Objects.requireNonNull(settingsPersister);
        this.launcherPersistence = Objects.requireNonNull(launcherPersistence);
        this.mainPresenter = Objects.requireNonNull(mainPresenter);
        this.versionsFromServer = Collections.emptyMap();
    }

    @Override
    public void onRequestCheckForUpdatesScreen(Language currentLanguage, boolean currentRightToLeft) throws LauncherException {
        try {
            this.versionsFromServer = this.updateChecker.getVersions();
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_CANNOT_CONTACT_SERVER);
        }
        this.view.displayScreen(currentLanguage, currentRightToLeft);
    }

    @Override
    public boolean isNewOpenMSXLauncherVersionAvailable() {
        return VersionUtils.isVersionNewer("1.14", this.versionsFromServer.get("openmsx-launcher"));
    }

    @Override
    public boolean isNewOpenMSXLauncherVersionDownloaded() {
        return this.updateChecker.isNewOpenMSXLauncherDownloaded();
    }

    @Override
    public boolean isNewExtraDataVersionAvailable() {
        String currentExtraDataVersion = null;
        try {
            currentExtraDataVersion = this.extraDataGetter.getExtraDataFileVersion();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return VersionUtils.isVersionNewer(currentExtraDataVersion, this.versionsFromServer.get("extra-data"));
    }

    @Override
    public boolean isNewScreenshotsVersionAvailable() {
        boolean answer = false;
        try {
            String screenshotsPath = this.settingsPersister.getSettings().getScreenshotsFullPath();
            if (screenshotsPath != null) {
                answer = VersionUtils.isVersionNewer(VersionUtils.getScreenshotsVersion(screenshotsPath), this.versionsFromServer.get("screenshots"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return answer;
    }

    @Override
    public boolean isScreenshotsSetInSettings() {
        boolean answer = false;
        try {
            String screenshotsPath = this.settingsPersister.getSettings().getScreenshotsFullPath();
            answer = screenshotsPath != null && new File(screenshotsPath, "version.txt").exists();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return answer;
    }

    @Override
    public void onRequestUpdateExtraData() throws LauncherException {
        try {
            this.updateChecker.getNewExtraDataFile();
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw new LauncherException(LauncherExceptionCode.ERR_CANNOT_CONTACT_SERVER);
        }
        catch (FileUpdateFailedException fufe) {
            LauncherLogger.logException(this, fufe);
            throw new LauncherException(LauncherExceptionCode.ERR_CANNOT_INSTALL_NEW_UPDATED_FILES);
        }
        Map<String, ExtraData> extraDataMap = null;
        try {
            extraDataMap = this.extraDataGetter.getExtraData();
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        try {
            this.launcherPersistence.getGamePersister().updateGameExtraDataInDatabases(extraDataMap);
        }
        catch (GamePersistenceException gpe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        this.mainPresenter.onUpdateExtraData();
    }

    @Override
    public void onRequestUpdateOpenMSXLauncher() throws LauncherException {
        try {
            this.updateChecker.getNewOpenMSXLauncher();
        }
        catch (IOException e) {
            throw new LauncherException(LauncherExceptionCode.ERR_CANNOT_CONTACT_SERVER);
        }
        catch (FileUpdateFailedException fufe) {
            throw new LauncherException(LauncherExceptionCode.ERR_CANNOT_INSTALL_NEW_UPDATED_FILES);
        }
    }

    @Override
    public void onRequestOpenDownloadPage() throws LauncherException {
        this.browseToDownloadLink();
    }

    private void browseToDownloadLink() throws LauncherException {
        try {
            ExternalLinksUtils.startBrowser(DOWNLOAD_URL);
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }
}

